package IPVGenerateVTD;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import IPVGenerateVTD.InferenceRule;
import IPVGenerateVTD.Path;
import IPVGenerateVTD.PathNode;
import IPVGenerateVTD.PathSet;

import com.ximpleware.AutoPilot;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;

public class IPVGenerateVTD {
	public static String directoryPath;
	
	public static String filepath;
	public static int PathNodeTypeElement = 1;
	public static int PathNodeTypeAttribute = 2;
	/**
	 * @param args
	 * @throws NavException 
	 * @throws XPathEvalException 
	 * @throws XPathParseException 
	 * @throws ModifyException 
	 * @throws IOException 
	 * @throws TranscodeException 
	 * @throws CloneNotSupportedException 
	 * @throws TransformerException 
	 * @throws SAXException 
	 * @throws ParserConfigurationException 
	 * @throws XPathExpressionException 
	 */
	public static void main(String[] args) throws XPathParseException, XPathEvalException, NavException, TranscodeException, IOException, XPathExpressionException, ParserConfigurationException, SAXException, TransformerException, CloneNotSupportedException, ModifyException {
		// TODO Auto-generated method stub
		if (args.length > 1) {
			directoryPath = args[1];
		} else if (args.length > 0) {
			JFileChooser fc = new JFileChooser();

			fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

			if (fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
				directoryPath = fc.getSelectedFile().getCanonicalPath();
			} else {
				throw new IllegalArgumentException("Missing or wrong path.");
			}
		} else{
			System.out.println("Please input the correct parameter:");
			System.out.println("filename");
			return;
		}
		
		File directory = new File(directoryPath);
		
		if (!directory.isDirectory() || directory.list().length == 0) {
			throw new IllegalArgumentException("Missing or wrong path.");
		} 
		
		filepath = directoryPath + File.separator + "MedicalDB";
		
		generateIPV(args[0]);
		
	}
	
	private static void generateIPV(String filename) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException, CloneNotSupportedException, XPathParseException, XPathEvalException, NavException, TranscodeException, ModifyException{

		ArrayList<InferenceRule> irs = ConstructInferenceRule();
		
		ArrayList potentialsecrets = readpotentialsecretpath(filename);
		
		String  fileName   = filepath + filename + ".xml"; 
		String  outputfilename   = "";
		String	resultfilename = filepath + filename + "_IPV.txt";
		File outputfile = new File(resultfilename);
		FileWriter outputfilewriter = new FileWriter(outputfile, true);
		//filepath + Integer.toString((i+1)*25000) + "_2.xml";
/*			String   fileName   = filepath + "1000.xml"; 
			String   outputfilename   = filepath + "1000_2.xml";*/
		
		long time1=System.currentTimeMillis();
		boolean firststep = true;
		boolean tempfilename = true;
		ArrayList Delta = new ArrayList();
		while(true){
			VTDGen vg = new VTDGen();
			XMLModifier xm = new XMLModifier();
			if (tempfilename){
				outputfilename = filepath + filename + "_2.xml";
				tempfilename = false;
			}else{
				outputfilename = filepath + filename + "_3.xml";
				tempfilename = true;					
			}
			OutputStream  os = new FileOutputStream(outputfilename);
			
			if (vg.parseFile(fileName,true)){
				VTDNav vn = vg.getNav();
				
				xm.bind(vn);
				if (firststep){
					Delta = potentialsecrets;
					firststep = false;
				}else{
					Delta = ConstructDelta(vn, irs);
				}
			
				ArrayList Gamma = new ArrayList();
			
				if (Delta.size() == 0){
					break;
				}
				
				for(int j=0; j<Delta.size(); j++){
					PathSet pathset = (PathSet)Delta.get(j);
					PathSet P = func_obtaincandidate(pathset);
					for(int k=0; k<P.pathset.size(); k++){
						Path p = (Path)P.pathset.get(k);
						proc_insertpath(Gamma, p);
					}
				}
				proc_refinepathset(Gamma);
				
				//weaken document
				while(!Delta.isEmpty()){
					PathSet P = (PathSet)Gamma.get(0);
					for(int j=1; j<Gamma.size(); j++){
						PathSet P1 = (PathSet)Gamma.get(j);
						if (P1.pathset.size() > P.pathset.size()){
							P = P1;
						}
					}
					proc_weakendocument(vn, xm, P);
					
					Gamma.remove(P);
					
					//delete corresponding path set from Delta
					for(int j=0; j<P.pathset.size(); j++){
						Path p = (Path)P.pathset.get(j);
						for(int k=0; k<Delta.size(); k++){
							PathSet delta = (PathSet)Delta.get(k);
							if (delta.id == p.id){
								Delta.remove(k);
								break;
							}
						}
						for(int k=0; k<Gamma.size(); k++){
							PathSet gamma = (PathSet)Gamma.get(k);
							for(int l=0; l<gamma.pathset.size(); l++){
								Path p1 = (Path)gamma.pathset.get(l);
								if (p1.id == p.id){
									gamma.pathset.remove(l);
								}
							}
						}
					}
				}
			}

			xm.output(os);
			
			os.close();
			fileName = outputfilename;
		} //
		long time = System.currentTimeMillis() - time1;
		outputfilewriter.write(filename + ":" + time + "\r\n");
		System.out.println(filename + ":" + time);	
		outputfilewriter.close();	
		
	}
	
	private static void proc_weakendocument(VTDNav vn,XMLModifier xm, PathSet P) throws NavException, UnsupportedEncodingException, XPathParseException, XPathEvalException{
		AutoPilot ap = new AutoPilot();
		ap.bind(vn);
		for(int i=0; i<P.pathset.size(); i++){
			Path p = (Path)P.pathset.get(i);
			String xpathstring = "/MedicalDB" + ConstructXPath(p, p.pnr);
			//System.out.println(xpathstring);
			ap.selectXPath(xpathstring);	
			int index;
			while((index = ap.evalXPath()) != -1){
				if (p.pnl.type == PathNodeTypeElement){
			//		System.out.println("deleted element:");
					//String elementcontent = vn.toString();
					
					long l = vn.getContentFragment();
					String elementcontent = vn.toString((int)l, (int)(l>>32));
					try{
						xm.remove();
						xm.insertBeforeElement(elementcontent);
					}catch (ModifyException e){
						e.toString();
					}
				}else{
				//	System.out.println("delete attribute:");
					
					String a = p.pnl.label;
					String aname = a.substring(a.indexOf('@')+1, a.indexOf('#'));
					
					if (aname.equals("value")){
						int textindex = vn.getText();
						if (textindex!=-1){
							try{
								xm.updateToken(textindex, "");
							}catch (ModifyException e){
		                    	e.toString();
		                    }
		                }
					}else{
						try{ 
							xm.removeAttribute(vn.getAttrVal(aname) - 1);
						}catch (ModifyException e){
							e.toString();
						}
					}
				}
				
			}
			ap.resetXPath();
		}
	}

	private static ArrayList<InferenceRule> ConstructInferenceRule(){
		ArrayList<InferenceRule> irs = new ArrayList<InferenceRule>();
		/*
		 * rules
		 * experiments: smith treat2, treat8
		 * experiments: Edward treat20, treat21
		 * experiments: Hunter treat26, treat28
		 * experiments: Longman treat32, treat33
		 * experiments: Lee	treat65, treat41
		 * experiments: Morley treat71, treat48
		 * experiments: Occam treat68, treat51
		 * experiments: Ralph treat74, treat54
		 * experiments: Roland treat67, treat55
		 * experiments: Simon treat70, treat56
		 */
		String irstrings1[][] = {
				{"Smith", "treatment2"},
				{"Smith", "treatment8"},
				{"Edward", "treatment20"},
				{"Edward", "treatment21"},
				{"Hunter", "treatment26"},
				{"Hunter", "treatment28"},
				{"Longman", "treatment32"},
				{"Longman", "treatment33"},
				{"Lee", "treatment65"},
				{"Lee", "treatment41"},
				{"Morley", "treatment71"},
				{"Morley", "treatment48"},
				{"Occam", "treatment68"},
				{"Occam", "treatment51"},
				{"Ralph", "treatment74"},
				{"Ralph", "treatment54"},
				{"Roland", "treatment67"},
				{"Roland", "treatment55"},
				{"Simon", "treatment70"},
				{"Simon", "treatment56"} 
		};
		/* rules:
		   treat4, treat5, hypertenson
		   treat8, treat9, heart attack
		   treat15, treat16, Apoplexy
		   treat17, treat18, Apoplexy
		   treat21, treat22, Bronchitis
		   treat25, treat26, Cirrhosis
		   treat29, treat30, Gastric Ulcer
		   treat32, treat34, Influenza
		   treat35, treat36, Rheumatoid Arthritis
		   treat38, treat39, Rheumatoid Arthritis
		   treat41, treat42, Neurasthenia
		   treat44, treat45, Cataract
		   treat48, treat49, Heterotropia
		   treat13, treat37, Pharyngitis
		   treat50, treat51, Diabetes
		   treat52, treat53, Headache
		   treat24, treat74, Scabies
		   treat47, treat55, Anemia
		   treat27, treat40, Angina Pectoris
		   treat78, treat56, Arteriosclerosis
		   treat36, treat57, Leukemia
		   treat82, treat58, Malnutrition
		 */		
		String irstrings2[][] = {
				{"treatment5", "treatment4", "Hypertension"},
				{"treatment8", "treatment9", "Heart Attack"},
				{"treatment15", "treatment16", "Apoplexy"},
				{"treatment18", "treatment17", "Apoplexy"},
				{"treatment21", "treatment22", "Bronchitis"},
				{"treatment25", "treatment26", "Cirrhosis"},
				{"treatment29", "treatment30", "Gastric Ulcer"},
				{"treatment32", "treatment34", "Influenza"},
				{"treatment35", "treatment36", "Rheumatoid Arthritis"},
				{"treatment39", "treatment38", "Rheumatoid Arthritis"},
				{"treatment42", "treatment41", "Neurasthenia"},
				{"treatment45", "treatment44", "Cataract"},
				{"treatment48", "treatment49", "Heterotropia"},
				{"treatment13", "treatment37", "Pharyngitis"},
				{"treatment50", "treatment51", "Diabetes"},
				{"treatment53", "treatment52", "Headache"},
				{"treatment24", "treatment74", "Scabies"},
				{"treatment47", "treatment55", "Anemia"},
				{"treatment27", "treatment40", "Angina Pectoris"},
				{"treatment78", "treatment56", "Arteriosclerosis"},
				{"treatment36", "treatment57", "Leukemia"},
				{"treatment82", "treatment58", "Malnutrition"} 
		};
		
	       /*
         * rules
         * symp1 symp3  treat4
         * symp1 symp4  treat6 
         * symp8 symp10  treat9
         * symp14 symp15 treat17 
         * symp18 symp20 treat26
         * symp19 symp22 treat30
         * symp13 symp23 treat34
         * symp25 symp26 treat38
         * symp11 symp27 treat41
         * symp28 symp29 treat44
         * symp16 symp30 treat49
         * symp31 symp32 treat66
         * symp6 symp33 treat51
         * symp17 symp34 treat52
         * symp12 symp59 treat54
         * symp35 symp37 treat55
         * symp55 symp38 treat40
         * symp24 symp39 treat56
         * symp40 symp41 treat57
         * symp21 symp42 treat58
         */
		String irstrings3[][] = {
				{"symptom1", "symptom3", "treatment4"},
				{"symptom1", "symptom4", "treatment6"},
				{"symptom8", "symptom10", "treatment9"},
				{"symptom14", "symptom15", "treatment17"},
				{"symptom18", "symptom20", "treatment26"},
				{"symptom19", "symptom22", "treatment30"},
				{"symptom13", "symptom23", "treatment34"},
				{"symptom25", "symptom26", "treatment38"},
				{"symptom11", "symptom27", "treatment41"},
				{"symptom28", "symptom29", "treatment44"},
				{"symptom16", "symptom30", "treatment49"},
				{"symptom31", "symptom32", "treatment66"},
				{"symptom6", "symptom33", "treatment51"},
				{"symptom17", "symptom34", "treatment52"},
				{"symptom12", "symptom59", "treatment54"},
				{"symptom35", "symptom37", "treatment55"},
				{"symptom55", "symptom38", "treatment40"},
				{"symptom24", "symptom39", "treatment56"},
				{"symptom40", "symptom41", "treatment57"},
				{"symptom21", "symptom42", "treatment58"} 
		};	
		for (int i=0; i<irstrings1.length; i++){
			InferenceRule ir = new InferenceRule();			
			for(int j=0; j<3; j++){
				Path path = new Path();
				PathNode pn1 = new PathNode();
				pn1.label = "patient";
				pn1.type = PathNodeTypeElement;
				path.pnr = pn1;
				path.PNE.add(pn1);
				path.Backbone.add(pn1);

				PathNode pn2 = new PathNode();
				pn2.label = "@pname#var_x";
				pn2.type = PathNodeTypeAttribute;
				pn2.parent = pn1;
				path.PNA.add(pn2);

				PathNode pn2_5 = new PathNode();
				PathNode pn2_6 = new PathNode();
				if (j == 0){
					pn2_6.label = "disease";
					pn2_6.type = PathNodeTypeElement;
					pn2_6.parent = pn1;
					path.PNE.add(pn2_6);
					path.Backbone.add(pn2_6);		
				}else{
					pn2_6.label = "treatments";
					pn2_6.type = PathNodeTypeElement;
					pn2_6.parent = pn1;
					path.PNE.add(pn2_6);
					path.Backbone.add(pn2_6);
					
					if (j == 2){
						pn2_5.label = "experiment";
						pn2_5.type = PathNodeTypeElement;
						pn2_5.parent = pn2_6;
						path.PNE.add(pn2_5);
						path.Backbone.add(pn2_5);
					}				
				}

				PathNode pn3 = new PathNode();
				if (j == 0){
					pn3.label = "doctor";
				}else{
					pn3.label = "treatment";
				}
				pn3.type = PathNodeTypeElement;
				if (j == 2){
					pn3.parent = pn2_5;
				}else{
					pn3.parent = pn2_6;
				}
				path.PNE.add(pn3);
				path.Backbone.add(pn3);

				PathNode pn4 = new PathNode();
				pn4.type = PathNodeTypeAttribute;
				if (j == 2){
					pn4.label = "@value#" + irstrings1[i][1];
				}else{
					pn4.label = "@value#" + irstrings1[i][j];
				}
				pn4.parent = pn3;
				path.PNA.add(pn4);
				path.Backbone.add(pn4);
				path.pnl = pn4;

				if (j == 2){
					ir.targetpath = path;
				}else{
					ir.conditionpart.add(path);
				}
			}
			irs.add(ir);
		}
		for (int i=0; i<irstrings2.length; i++){
			InferenceRule ir = new InferenceRule();			
			for(int j=0; j<3; j++){
				Path path = new Path();
				PathNode pn1 = new PathNode();
				pn1.label = "patient";
				pn1.type = PathNodeTypeElement;
				path.pnr = pn1;
				path.PNE.add(pn1);
				path.Backbone.add(pn1);

				PathNode pn2 = new PathNode();
				pn2.label = "@pname#var_x";
				pn2.type = PathNodeTypeAttribute;
				pn2.parent = pn1;
				path.PNA.add(pn2);

				PathNode pn2_6 = new PathNode();
				if (j != 2){
					pn2_6.label = "treatments";
					pn2_6.type = PathNodeTypeElement;
					pn2_6.parent = pn1;
					path.PNE.add(pn2_6);
					path.Backbone.add(pn2_6);		
				}
				
				PathNode pn3 = new PathNode();
				if (j == 2){
					pn3.label = "disease";
				}else{
					pn3.label = "treatment";
				}
				pn3.type = PathNodeTypeElement;
				if (j == 2){
					pn3.parent = pn1;
				}else{
					pn3.parent = pn2_6;
				}
				path.PNE.add(pn3);
				path.Backbone.add(pn3);

				PathNode pn4 = new PathNode();
				pn4.type = PathNodeTypeAttribute;
				if (j == 2){
					pn4.label = "@dname#" + irstrings2[i][j];
				}else{
					pn4.label = "@value#" + irstrings2[i][j];
				}
				pn4.parent = pn3;
				path.PNA.add(pn4);
				path.Backbone.add(pn4);
				path.pnl = pn4;

				if (j == 2){
					ir.targetpath = path;
				}else{
					ir.conditionpart.add(path);
				}
			}
			irs.add(ir);
		}
		
		for (int i=0; i<irstrings3.length; i++){
			InferenceRule ir = new InferenceRule();			
			for(int j=0; j<3; j++){
				Path path = new Path();
				PathNode pn1 = new PathNode();
				pn1.label = "patient";
				pn1.type = PathNodeTypeElement;
				path.pnr = pn1;
				path.PNE.add(pn1);
				path.Backbone.add(pn1);

				PathNode pn2 = new PathNode();
				pn2.label = "@pname#var_x";
				pn2.type = PathNodeTypeAttribute;
				pn2.parent = pn1;
				path.PNA.add(pn2);

				PathNode pn2_6 = new PathNode();
				if (j != 2){
					pn2_6.label = "symptoms";
				}else{
					pn2_6.label = "treatments";
				}
				pn2_6.type = PathNodeTypeElement;
				pn2_6.parent = pn1;
				path.PNE.add(pn2_6);
				path.Backbone.add(pn2_6);		
				
				PathNode pn3 = new PathNode();
				if (j == 2){
					pn3.label = "treatment";
				}else{
					pn3.label = "symptom";
				}
				pn3.type = PathNodeTypeElement;
				pn3.parent = pn2_6;
				path.PNE.add(pn3);
				path.Backbone.add(pn3);

				PathNode pn4 = new PathNode();
				pn4.type = PathNodeTypeAttribute;
				pn4.label = "@value#" + irstrings3[i][j];
				pn4.parent = pn3;
				path.PNA.add(pn4);
				path.Backbone.add(pn4);
				path.pnl = pn4;

				if (j == 2){
					ir.targetpath = path;
				}else{
					ir.conditionpart.add(path);
				}
			}
			irs.add(ir);
		}		
		
		return irs;	
	}	
	
	private static ArrayList readpotentialsecretpath(String filename) throws IOException{
	//	ArrayList als[] = new ArrayList[Filenum];
		ArrayList als = new ArrayList();
		//for(int i=0; i<Filenum; i++){
			//als[i] = new ArrayList();
			String psFileName = filepath + "potentialsecret" + filename + ".txt";
			//String psFileName = filepath + "potentialsecret" + "1000.txt";
			File psFile = new File(psFileName);
			BufferedReader reader = new BufferedReader(new FileReader(psFile));  
			String tempString = null;
			int id = 0;
			while ((tempString = reader.readLine()) != null){
				ArrayList al = new ArrayList();

				tempString = tempString.replace("/MedicalDB", "");
				Path path = new Path();
				PathNode pn = new PathNode();
				pn.label = "patient";
				pn.type = PathNodeTypeElement;
				path.pnr = pn;
				path.PNE.add(pn);
				path.Backbone.add(pn);
				tempString = tempString.replace("//patient", "");
				
				PathNode pn1 = new PathNode();
				int index = tempString.indexOf("[");
				String pnamestr = tempString.substring(tempString.indexOf("["), tempString.indexOf("]") + 1);
				pnamestr = pnamestr.replace("[", "");
				pnamestr = pnamestr.replace(" = \"", "#");
				pnamestr = pnamestr.replace("\"]", "");
				pn1.label = pnamestr;
				pn1.type = PathNodeTypeAttribute;
				pn1.parent = pn;
				path.PNA.add(pn1);
				tempString = tempString.substring(tempString.indexOf("]") + 1);
				
				
				if (tempString.indexOf("experiment") != -1){
					PathNode pn2_5 = new PathNode();
					pn2_5.label = "treatments";
					pn2_5.type = PathNodeTypeElement;
					pn2_5.parent = pn;
					path.PNE.add(pn2_5);
					path.Backbone.add(pn2_5);
					
					PathNode pn2 = new PathNode();
					pn2.label = "experiment";
					pn2.type = PathNodeTypeElement;
					pn2.parent = pn2_5;
					path.PNE.add(pn2);
					path.Backbone.add(pn2);
					path.pnl = pn2;
				}else{
					PathNode pn2 = new PathNode();
					pn2.label = "disease";
					pn2.type = PathNodeTypeElement;
					pn2.parent = pn;
					path.PNE.add(pn2);
					path.Backbone.add(pn2);
					
					PathNode pn3 = new PathNode();
					String diseasestr = tempString.substring(tempString.indexOf("["), tempString.indexOf("]") + 1);
					diseasestr = diseasestr.replace("[", "");
					diseasestr = diseasestr.replace("@dname = \"", "@dname#");
					diseasestr = diseasestr.replace("\"]", "");
					pn3.label = diseasestr;
					pn3.parent = pn2;
					pn3.type = PathNodeTypeAttribute;
					path.PNA.add(pn3);
					path.Backbone.add(pn3);
					path.pnl = pn3;
				}
				
				PathSet pathset = new PathSet();
				id++;
				pathset.id = id;
				pathset.pathset.add(path);
				als.add(pathset);
			}  
			reader.close();
		//}
		return als;
	}

	private static PathSet func_obtaincandidate(PathSet pathset) throws CloneNotSupportedException{
		String availableelementtype[][] = {
				{"MedicalDB", "100"},
				{"patient", "11"},
				{"treatments", "10"},
				{"symptoms", "9"},
				{"symptom", "8"},
				{"disease", "7"},
				{"treatment", "6"},
				{"doctor", "5"},
				{"experiment", "4"}
		};
		
		PathSet candidates = new PathSet();
		candidates.id = pathset.id;
		
		//the first principle
		for(int i=0; i<pathset.pathset.size(); i++){
			Path path = (Path)pathset.pathset.get(i);
			
			Enumeration e = Collections.enumeration(path.PNA);
			while(e.hasMoreElements()){
				PathNode pa = (PathNode)e.nextElement();
				Enumeration e1 = Collections.enumeration(path.PNE);
				while(e1.hasMoreElements()){
					PathNode pe = (PathNode)e1.nextElement();
					if (pe.equals(pa.parent)){
						boolean aetype = false;
						for (int j=0; j<availableelementtype.length; j++){
							if (pe.label.equals(availableelementtype[j][0])){
								aetype = true;
								break;
							}
						}
						if (!aetype){
							Path newpath = copypath(path);
							newpath.id = pathset.id;
							newpath.Backbone.clear();
							newpath.pnl = pa;
							newpath.Backbone.add(pa);
							newpath.Backbone.add(pe);
							if (pe.parent != null){
								while(true){
									Enumeration e2 = Collections.enumeration(path.PNE);
									while(e2.hasMoreElements()){
										PathNode pe1 = (PathNode)e2.nextElement();
										if (pe1.equals(pe.parent)){
											newpath.Backbone.add(pe1);
											pe = pe1;
											break;
										}
									}
									if (pe.parent == null){
										break;
									}
								}
							}
							candidates.pathset.add(newpath);
						}
					}
				}
			}
		}
		
			//the second part
		if (candidates.pathset.size() == 0){
			for(int i=0; i<pathset.pathset.size(); i++){
				Path path = (Path)pathset.pathset.get(i);		
				Enumeration e = Collections.enumeration(path.PNE);
				while(e.hasMoreElements()){
					PathNode pe = (PathNode)e.nextElement();
					boolean aetype = false;
					for (int j=0; j<availableelementtype.length; j++){
						if (pe.label.equals(availableelementtype[j][0])){
							aetype = true;
							break;
						}
					}
					if (!aetype){
						Path newpath = copypath(path);
						newpath.id = pathset.id;
						newpath.Backbone.clear();
						newpath.pnl = pe;
						newpath.Backbone.add(pe);
						if (pe.parent != null){
							while(true){
								Enumeration e2 = Collections.enumeration(path.PNE);
								while(e2.hasMoreElements()){
									PathNode pe1 = (PathNode)e2.nextElement();
									if (pe1.equals(pe.parent)){
										newpath.Backbone.add(pe1);
										pe = pe1;
										break;
									}
								}
								if (pe.parent == null){
									break;
								}
							}
						}
						candidates.pathset.add(newpath);
					}
				}
			}
		}
		
		int smallestnumber = 100;
		//the third part, the first half
		if (candidates.pathset.size() == 0){			
			for(int i=0; i<pathset.pathset.size(); i++){			
				Path path = (Path)pathset.pathset.get(i);							
				Enumeration e = Collections.enumeration(path.PNE);
				while(e.hasMoreElements()){
					PathNode pe = (PathNode)e.nextElement();
					for (int j=0; j<availableelementtype.length; j++){
						if (pe.label.equals(availableelementtype[j][0])){
							int num = Integer.valueOf(availableelementtype[j][1]);
							if (smallestnumber > num){
								smallestnumber = num;
							}
							break;
						}
					}
				}
			}
			
			for(int i=0; i<pathset.pathset.size(); i++){			
				Path path = (Path)pathset.pathset.get(i);							
				Enumeration e = Collections.enumeration(path.PNA);
				while(e.hasMoreElements()){
					PathNode pa = (PathNode)e.nextElement();
					Enumeration e1 = Collections.enumeration(path.PNE);
					while(e1.hasMoreElements()){
						PathNode pe = (PathNode)e1.nextElement();
						if (pe.equals(pa.parent)){
							for (int j=0; j<availableelementtype.length; j++){
								if (pe.label.equals(availableelementtype[j][0])){
									if (smallestnumber == Integer.valueOf(availableelementtype[j][1])){								
										//Path newpath = (Path)path.clone();
										Path newpath = copypath(path);
										newpath.id = pathset.id;
										newpath.Backbone.clear();
										newpath.pnl = pa;
										newpath.Backbone.add(pa);
										newpath.Backbone.add(pe);
										if (pe.parent != null){
											while(true){
												Enumeration e2 = Collections.enumeration(path.PNE);
												while(e2.hasMoreElements()){
													PathNode pe1 = (PathNode)e2.nextElement();
													if (pe1.equals(pe.parent)){
														newpath.Backbone.add(pe1);
														pe = pe1;
														break;
													}
												}
												if (pe.parent == null){
													break;
												}
											}
										}
										candidates.pathset.add(newpath);
									}
									break;
								}
							}
							break;
						}
					}
				}
			}
		}
		
		//the third part, the second half
		if (candidates.pathset.size() == 0){
			for(int i=0; i<pathset.pathset.size(); i++){				
				Path path = (Path)pathset.pathset.get(i);							
				Enumeration e = Collections.enumeration(path.PNE);
				while(e.hasMoreElements()){
					PathNode pe = (PathNode)e.nextElement();
					for (int j=0; j<availableelementtype.length; j++){
						if (pe.label.equals(availableelementtype[j][0])){
							if (smallestnumber == Integer.valueOf(availableelementtype[j][1])){								
								Path newpath = copypath(path);
								newpath.id = pathset.id;
								newpath.Backbone.clear();
								newpath.pnl = pe;
								newpath.Backbone.add(pe);
								if (pe.parent != null){
									while(true){
										Enumeration e2 = Collections.enumeration(path.PNE);
										while(e2.hasMoreElements()){
											PathNode pe1 = (PathNode)e2.nextElement();
											if (pe1.equals(pe.parent)){
												newpath.Backbone.add(pe1);
												pe = pe1;
												break;
											}
										}
										if (pe.parent == null){
											break;
										}
									}
								}
								candidates.pathset.add(newpath);
							}
							break;
						}
					}
				}
			}		
		}
		
		return candidates;
	}

	private static void proc_insertpath(ArrayList Gamma, Path p){
		boolean getbackboneequ = false;
		for(int i=0; i<Gamma.size(); i++){
			PathSet ps = (PathSet)Gamma.get(i);
			if (!ps.pathset.isEmpty()){
				Path p1 = (Path)ps.pathset.get(0);
				if (backboneequ(p, p1)){
					ps.pathset.add(p);
					getbackboneequ = true;
				}
			}
		}
		if (!getbackboneequ){
			PathSet ps = new PathSet();
			ps.pathset.add(p);
			ps.id = p.id;
			Gamma.add(ps);
		}
	}	
	
	private static boolean backboneequ(Path p1, Path p2){
		PathNode pn1_1 = p1.pnl;
		PathNode pn2_1 = p2.pnl;
		
		if ((!(pn1_1.label.equals(pn2_1.label))) || (pn1_1.type != pn2_1.type)){
			return false;
		}
		
		while(true){
			Enumeration e = Collections.enumeration(p1.Backbone);
			if (pn1_1.parent == null){
				if (pn2_1.parent == null){
					break;
				}else{
					return false;
				}
			}
			while(e.hasMoreElements()){
				PathNode pn1_2 = (PathNode)e.nextElement();
				if (pn1_2.equals(pn1_1.parent)){
					Enumeration e1 = Collections.enumeration(p2.Backbone);
					PathNode pn2_2 = null;
					while(e1.hasMoreElements()){
						pn2_2 = (PathNode)e1.nextElement();
						if (pn2_2.equals(pn2_1.parent)){
							break;
						}
					}
					if (pn2_2 == null){
						return false;
					}else if ((!(pn2_2.label.equals(pn1_2.label))) ||
							(pn2_2.type != pn1_2.type)){
						return false;
					}else{
						pn1_1 = pn1_2;
						pn2_1 = pn2_2;
					}
					break;
				}
			}
		}		
		return true;
	}
	
	private static void proc_refinepathset(ArrayList Gamma){
		for(int i=0; i<Gamma.size(); i++){
			PathSet ps = (PathSet)Gamma.get(i);
			while(true){
				boolean found = false;
				for (int j=0; j<ps.pathset.size(); j++){
					Path p = (Path)ps.pathset.get(j);
					for (int k=j+1; k<ps.pathset.size(); k++){
						Path p1 = (Path)ps.pathset.get(k);
						if (p1.id == p.id){
							found = true;
							ps.pathset.remove(p1);
							break;
						}
					}
					if (found){
						break;
					}
				}
				if (!found){
					break;
				}
			}
		}
	}	
	
	private static void testmodify() throws XPathParseException, XPathEvalException, NavException, ModifyException, TranscodeException, IOException{
		String filename = directoryPath + File.separator + "MedicalDB2500.xml";
		String outputfilename = directoryPath + File.separator + "MedicalDB25000_1.xml";
		
		VTDGen vg = new VTDGen();
		AutoPilot ap = new AutoPilot();
		AutoPilot ap1 = new AutoPilot();
		AutoPilot ap2 = new AutoPilot();
		XMLModifier xm = new XMLModifier();
		OutputStream  os = new FileOutputStream(outputfilename);
		if (vg.parseFile(filename,true)){
			VTDNav vn = vg.getNav();
			ap.bind(vn);
			xm.bind(vn);
		
			String xpathstring = "/MedicalDB/patient/treatments/experiment";
			
			ap.selectXPath(xpathstring);
			int index;
			while ((index=ap.evalXPath()) != -1){
				System.out.println(vn.getAttrCount());
				System.out.println(vn.getContentFragment());
				System.out.println(vn.getTokenCount());
				System.out.println(vn.getTokenDepth(vn.getCurrentIndex()));
				System.out.println(vn.getTokenOffset(vn.getCurrentIndex()));
				System.out.println(vn.getTokenLength(vn.getCurrentIndex()));
				System.out.println(vn.getNormalizedStringLength(vn.getCurrentIndex()));
				System.out.println(vn.toString(vn.getCurrentIndex()));
				long l = vn.getContentFragment();
				System.out.println((l));
				System.out.println((l>>32));
				System.out.println(vn.toString((int)l, (int)(l>>32)));
				String elementcontent = vn.toString((int)l, (int)(l>>32));
				xm.remove();
				
				xm.insertBeforeElement(elementcontent);
				
				
			}
			xm.output(os);
		}
		os.close();
	}
	
    private static Path copypath(Path p){
    	Path newp = new Path();
    	newp.pnr = p.pnr;
    	newp.pnl = p.pnl;
    	newp.id = p.id;
    	
    	Enumeration e = Collections.enumeration(p.PNE);
    	while(e.hasMoreElements()){
    		PathNode pn = (PathNode)e.nextElement();
    		PathNode pn1 = new PathNode();
    		newp.PNE.add(pn);
    	}
    	
    	e = Collections.enumeration(p.PNA);
    	while(e.hasMoreElements()){
    		PathNode pn = (PathNode)e.nextElement();
    		newp.PNA.add(pn);
    	}
    	
    	e = Collections.enumeration(p.Backbone);
    	while(e.hasMoreElements()){
    		PathNode pn = (PathNode)e.nextElement();
    		newp.Backbone.add(pn);
    	}
    	
    	
    	return newp;
    }
    
	private static ArrayList ConstructDelta(VTDNav vn, ArrayList irs) throws CloneNotSupportedException, XPathExpressionException, XPathParseException, XPathEvalException, NavException{
		ArrayList Delta = new ArrayList();
		AutoPilot ap = new AutoPilot();
		AutoPilot ap1 = new AutoPilot();
		AutoPilot ap2 = new AutoPilot();
		ap.bind(vn);
		ap1.bind(vn);
		ap2.bind(vn);
		int id = 0;	
		for(int i=0; i<irs.size(); i++){
			InferenceRule ir = (InferenceRule)irs.get(i);
			
			ArrayList conditionpart = ir.conditionpart;
			Path condition1 = (Path)ir.conditionpart.get(0);

			Path path = copypath(condition1);
			Enumeration e = Collections.enumeration(path.PNA);
			String attributename = "";
			while (e.hasMoreElements()){
				PathNode pn = (PathNode)e.nextElement();
				if (pn.label.contains("var_")){
					attributename = pn.label.substring(pn.label.indexOf("@") + 1, pn.label.indexOf("#"));
					Enumeration e1 = Collections.enumeration(path.PNE);
					PathNode pn1 = null;
					while (e1.hasMoreElements()){
						pn1 = (PathNode)e1.nextElement();
						if (pn1.equals(pn.parent)){
							break;
						}
					}
					if (pn1 != null){
						path.pnl = pn1;
					}
					path.Backbone.clear();
					path.Backbone.add(pn1);
					path.PNA.remove(pn);
					while(true){
						if (pn1.parent == null){
							break;
						}
						e1 = Collections.enumeration(path.PNE);
						PathNode pn2 = null;
						while (e1.hasMoreElements()){
							pn2 = (PathNode)e1.nextElement();
							if (pn2.equals(pn1.parent)){
								break;
							}
						}
						if (pn2 != null){
							path.Backbone.add(pn2);
							pn1 = pn2;
						}
					}
					break;
				}				
			}
			
			condition1 = (Path)ir.conditionpart.get(0);

			ArrayList<String> avaluelist = new ArrayList();
			
			String xpathstring = "/MedicalDB" + ConstructXPath(path, path.pnr);
			
			ap.selectXPath(xpathstring);
			//get all the candidate value of an attribute
			while (ap.evalXPath() != -1){
				String attributevalue = "";
				if (attributename.equals("value")){
					long l = vn.getText();
					avaluelist.add(vn.toString((int )l));

				}else{
					long l = vn.getAttrVal(attributename);
					avaluelist.add(vn.toString((int )l));
				}
			}
			
			ap.resetXPath();
			//Now we have all the candidate values of the variable for the first condition
			//Construct the xpath of the second part for every candidate value
			
			for(int k=0; k<avaluelist.size(); k++){
				String attributevalue = avaluelist.get(k);
				PathSet pathset = new PathSet();
				boolean violated = true;
				
				for(int j=0; j<conditionpart.size(); j++){
					Path pp = (Path)conditionpart.get(j);
					Path p = copypath(pp);
					pathset.pathset.add(p);
					Enumeration e1 = Collections.enumeration(p.PNA);
					while(e1.hasMoreElements()){
						PathNode pn = (PathNode)e1.nextElement();
						if (pn.label.indexOf("var_") != -1){
							PathNode newpn = new PathNode();
							newpn.type = pn.type;
							newpn.parent = pn.parent;
							newpn.label = pn.label.replace("var_x", attributevalue);
							p.PNA.remove(pn);
							p.PNA.add(newpn);
							if (p.Backbone.contains(pn)){
								p.Backbone.remove(pn);
								p.Backbone.add(newpn);
							}
							
							break;
						}
					}
					if (j > 0){
						xpathstring = "/MedicalDB" + ConstructXPath(p, p.pnr);
						ap1.selectXPath(xpathstring);
						//	System.out.println(xpathstring);
						if (ap1.evalXPath() == -1){
								//now the conditon part is satisfied for the attribute value
							violated = false;
							break;
						//		System.out.println(attributevalue);
						}
						ap1.resetXPath();
					}
				}
				
				
				if (violated){
					Path p = copypath(ir.targetpath);
					Enumeration e1 = Collections.enumeration(p.PNA);
					while(e1.hasMoreElements()){
						PathNode pn = (PathNode)e1.nextElement();
						if (pn.label.indexOf("var_") != -1){
							PathNode newpn = new PathNode();
							newpn.type = pn.type;
							newpn.parent = pn.parent;
							newpn.label = pn.label.replace("var_x", attributevalue);
							p.PNA.remove(pn);
							p.PNA.add(newpn);
							if (p.Backbone.contains(pn)){
								p.Backbone.remove(pn);
								p.Backbone.add(newpn);
							}
							break;
						}
					}					
					xpathstring = "/MedicalDB" + ConstructXPath(p, p.pnr);
					ap2.selectXPath(xpathstring);
					if (ap2.evalXPath() == -1){
						violated = true;
					}else{
						violated = false;
					}
					ap2.resetXPath();
				}
				
				if (violated){
					id++;
					pathset.id = id;
					Delta.add(pathset);
				}
				
			}
		}
					
		return Delta;
	}

	private static String ConstructXPath(Path path, PathNode pn){
		String xpath = pn.label;
		if (pn.label.equals("treatment")){
			xpath = "//" + xpath;
		}else{
			xpath = "/" + xpath;
		}
				
			boolean thefirstbranch = true;
			PathNode pn_backbonechild = null;
			Enumeration e = Collections.enumeration(path.Backbone);
			
			while(e.hasMoreElements()){
				PathNode pn1 = (PathNode)e.nextElement();
				if ((pn1.parent != null)&&(pn1.parent.equals(pn))){
						if (path.PNE.contains(pn1)){
							pn_backbonechild = pn1;
						}
						break;
				}
			}
			
			e = Collections.enumeration(path.PNE);
			while(e.hasMoreElements()){
				PathNode pn1 = (PathNode)e.nextElement();
				if ((pn1.parent != null)&&(pn1.parent.equals(pn))){
					if ((pn_backbonechild == null) || !(pn1.equals(pn_backbonechild))){
						if (thefirstbranch){
							xpath = xpath + "[." + ConstructXPathBranch(path, pn1);
							thefirstbranch = false;
						}else{
							xpath = xpath + " and ." + ConstructXPathBranch(path, pn1);
						}
					}
				}
			}
			
			e = Collections.enumeration(path.PNA);
			while(e.hasMoreElements()){
				PathNode pn1 = (PathNode)e.nextElement();
				if (pn1.parent.equals(pn)){
					String xpath_branch = "";
					if (pn1.label.contains("@value#")){
						xpath_branch = pn1.label.replace("@value#", ". = \"");
					}else{
						xpath_branch = pn1.label.replace("#", " = \"");
					}
					xpath_branch = xpath_branch + "\"";
					if (thefirstbranch){
						xpath = xpath + "[" + xpath_branch;
						thefirstbranch = false;
					}else{
						xpath = xpath + " and " + xpath_branch;
					}
				}
			}
			
			if (!thefirstbranch){
				xpath = xpath + "]";
			}
			
			if (pn_backbonechild != null){
				xpath = xpath + ConstructXPath(path, pn_backbonechild); 
				
			}
		
		return xpath;
	}
	
	private static String ConstructXPathBranch(Path path, PathNode pn){
		String xpath = pn.label;
		if (pn.label.equals("treatment")){
			xpath = "//" + xpath;
		}else{
			xpath = "/" + xpath;
		}
		boolean hasbackbonechild =false;
		boolean thefirstbranch = true;
		
		PathNode pn_backbonechild = null;
		Enumeration e = Collections.enumeration(path.PNE);
		
		while(e.hasMoreElements()){
			PathNode pn1 = (PathNode)e.nextElement();
			if ((pn1.parent != null)&&(pn1.parent.equals(pn))){
				if (!hasbackbonechild){
					pn_backbonechild = pn1;
				}else{
					String xpath_branch = ConstructXPathBranch(path, pn1);
					if (thefirstbranch){
						xpath = xpath + "[" + xpath_branch;
						thefirstbranch = false;
					}else{
						xpath = xpath + " and " + xpath_branch;
					}
				}
			}
		}
		
		e = Collections.enumeration(path.PNA);		
		while(e.hasMoreElements()){
			PathNode pn1 = (PathNode)e.nextElement();
			if (pn1.parent.equals(pn)){
				String xpath_branch = "";
				if (pn1.label.contains("@value#")){
					xpath_branch = pn1.label.replace("@value#", ". = \"");
				}else{
					xpath_branch = pn1.label.replace("#", " = \"");
				}
				xpath_branch = xpath_branch + "\"";
				if (thefirstbranch){
					xpath = xpath + "[" + xpath_branch;
					thefirstbranch = false;
				}else{
					xpath = xpath + " and " + xpath_branch;
				}
			}
		}
		
		if (!thefirstbranch){
			xpath = xpath + "]";
		}
		
		if (pn_backbonechild != null){
			xpath = xpath + ConstructXPathBranch(path, pn_backbonechild); 
		}
		
		return xpath;
	}
	
}
